# Skill: cc-activate-license
Version: 1.0.0

## Description
Orchestrates the activation of a CCOS license. This skill handles the handshake with Supabase, validates the license key and email, downloads and installs the user intelligence assets, and updates the local identity profile.

## Trigger
Invoke this skill when a user wants to activate their CCOS license or sync their profile data from the remote server.

## Tools Required
- `python3`
- `read_file`
- `write_file`
- `list_dir`

## Arguments
- `command`: The operation to perform ('activate' or 'update').
- `key`: (Required for activate) The user's License Key (string).
- `email`: (Required for activate) The email address used for purchase (string).
- `os`: The user's operating system (e.g., "Mac", "Windows").

## Execution Flow
1. Check if Python 3 is available.
2. If `command` is 'activate', run `scripts/activate.py`.
3. If `command` is 'update', run `scripts/update.py`.
4. Parse the JSON output from the script.
5. If successful, report the results (activation details or update status).
6. If it fails, report the specific error message.

## Output Format
Markdown response containing the activation status and verification details.
