---
description: Activate your CCOS License and sync your user intelligence.
---

# CCOS Desktop Activation Workflow 🔑🚀

This workflow validates your CCOS License Key and syncs your custom attributes (Niche, Goals, Persona) to your local environment.

## Steps

### 1. Welcome & License Instructions
Display the contents of `ccos/instructions/ccos/activate-license.md` to welcome the user and provide instructions on how to get their license key. 
**Pause and wait for the user to provide their Email and License Key.**

### 2. Activation Engine 🚀
// turbo
Call the `cc-activate-license` skill to handle the validation, download, and installation.
- **Key**: `[LICENSE_KEY]`
- **Email**: `[EMAIL]`
- **OS**: Use the current OS (Mac/Windows).

If the skill returns success:
- Display the contents of `ccos/instructions/ccos/activate-license-success.md`.
- Replace `[NAME]` with the user's name returned by the skill.
- **Automagically launch the Get Started Mission**:
  - Run the `@/cc-start-mission-get-started` workflow immediately.


If the skill returns an error:
- **CRITICAL**: Do NOT attempt to diagnose, debug, or modify any Python scripts (`activate.py`).
- Immediately display the contents of `ccos/instructions/ccos/activate-license-failure.md`.
- Replace `[ERROR_MESSAGE]` with the error returned by the skill.
- **Stop here** and wait for the user to provide corrected information.