# CCOS Repository

The `ccos` directory serves as the central knowledge base for the Course Creators OS. It provides the "context" required for the AI and the user to maintain consistency, accuracy, and alignment across all projects.

When using workflows or asking the "system" to generate content, this folder is the primary source of truth.

> [!WARNING]
> **Protected Directories: DO NOT MODIFY**
>
> 1.  **`ccos/system/`**: This directory contains the "Brain" of the OS—core prompts, design standards, and system logic. These files are updated automatically by CCOS updates. **Any manual changes here will be overwritten or cause system errors.**
> 2.  **`.agent/workflows/`**: The system workflows (prefixed with `wf-`) are core functionality. **Do not modify these.** You are free to create your own custom workflows (e.g., `my-custom-workflow.md`), but leave the standard library untouched to ensure your OS continues to function correctly.

## Directory Structure

### 1. Company Context (`my-content/[company-slug]/`)
The "Memory" for your specific projects. This is where your data lives.
*   **`[name].context.md`**: The Unified Context Bundle. This single file contains your Brand, ICP, Tone, and Strategic data, optimized for AI processing.
*   **`courses/`**: Course content hierarchy:
    *   `[course]/` -> `[chapter]/` -> `[lesson]/`: Where your HTML lessons and lesson-specific context live.

### 1.5 Knowledge Context (`ccos/context/`)
Knowledge and frameworks used to generate high quality content.
*   **`lesson-design/`**: Instructional design patterns and educational frameworks.
*   **`thinkific-course-player/`**: Technical specs and constraints of the Thinkific Course Player (the host environment).
*   **`thinkific-graphql/`**: Documentation and query library for the Thinkific API integration.

### 1.7 System Instructions (`ccos/instructions/`)
Core standards and best practices for creating content.
*   **`html/`**: Technical standards, templates, and best practices for HTML development.

### 1.9 Missions (`ccos/missions/`)
Structured tasks and guided experiences to help you build your business.
*   **`about.md`**: Overview of the mission system and focus areas.
*   **`[focus-area]/`**: Specific missions organized by category (e.g., Playing, Learning, Building).

### 1.11 External Resources (`ccos/ccos-resources.md`)
Quick links and information for the CCOS Ecosystem.
*   **Community**: Thinkific-based group for help and feedback.
*   **Live Events**: Weekly workshops and replays.

### 2. System Resources (`ccos/system/`)
**⚠️ READ-ONLY REFERENCE**
Shared standards, templates, and tools used across all projects.
*   **`ccos-users.md`**: Persona descriptions and strategies for different user niches.
*   **`logo/`**: Brand assets and logos for Course Creator OS.
*   **`prompt-library/`**: System prompts used by the agents.
*   **`releases/`**: Changelogs and version history for Course Creator OS.
*   **`scripts/`**: Automation tools for content generation and management.

## Usage

*   **Workflows**: Automated workflows are designed to look for context in `my-content/[company]/`.
*   **Manual Reference**: Use `system/` for standards and `my-content/[company]/` for specific project details.
