# 🧭 Focus & Missions: Your Personal Course GPS

Ever feel overwhelmed by the "blank page" problem? CCOS solves this with **Focus Areas** and **Missions**. 

This system acts as your personal GPS, guiding you through specific stages of your business so you always know exactly what to work on next.

---

## 🔍 Focus Areas: "What's the Goal?"
A **Focus Area** is a broad category of work. When you're in a certain "Focus," the agent knows to ignore distractions and help you with that specific part of your business.

**Examples include:**
- **Course Lessons**: Drafting and designing your educational content.
- **Site Pages**: Building your sales and landing pages.
- **Using CCOS**: Learning the ropes of the system (where you are now!).

---

## 🎯 Missions: "What's the Task?"
Inside every Focus Area are **Missions**. A mission is a step-by-step checklist designed to get a specific result.

Instead of a long, confusing conversation, a mission breaks everything down into bite-sized actions.

![Screenshot Placeholder: A mission file open in the editor with checkboxes]

---

## 🚦 How to Use the GPS
You can change your focus at any time to match your current needs.

1.  **Type `/cc-start-mission`** in the chat.
2.  **Pick a Focus Area** from the list.
3.  **Choose a Mission** that matches your current problem.

---

## 🛠️ Managing Your Journey
Beyond just picking a mission, you have several "Navigational Tools" to help you move quickly:

- **`/cc-list-missions`**: Use this if you're already in a Focus Area but want to see your other mission options again.
- **`/cc-resume-mission`**: The "Pick Up Where I Left Off" button. If you start a new chat, this command instantly brings you back to your last active mission so you never lose momentum.
- **`/cc-jump-to-mission`**: Know exactly what you want to do? This skips the menus and lets you search for a specific mission by name.

### 💡 The "One Step at a Time" Rule
Missions are built to keep you from feeling overwhelmed. We only show you **Step 1** first. Once you're done, you type `/cc-next` to see the next step. It’s the fastest, stress-free way to build a business.

---

## 🏠 Everything in One Place
The biggest killer of productivity is "Tab Fatigue"—jumping between your course, your email, and random tutorials. 

**Missions keep you right where you are:**
- 📸 **Visuals Included**: Screenshots and diagrams appear right in your chat.
- 📹 **Step-by-Step Videos**: We link you to the exact video you need for the task at hand.
- ⏳ **Work at Your Own Pace**: You can start a mission today, close Antigravity, and resume exactly where you left off tomorrow. Just use `/cc-resume-mission` to get back into the flow.

---

## 🚀 Why This Matters
Most entrepreneurs fail because they try to do everything at once. **Focus & Missions** give you the permission to do one thing exceptionally well before moving to the next.
