# Course Creator OS (Desktop)

**The "Heavy Lifter" for Professional Course Creators.**

Course Creator OS (Desktop) is a local-first, AI-powered operating system designed to automate the heavy lifting of course creation. Unlike browser-based tools that just "chat," CCOS Desktop runs directly on your machine, accessing your local files to build, audit, and deploy entire course assets (websites, lessons, emails) in seconds.

It is not just a tool; it is a **Senior Employee** that lives on your computer, knows your brand, protects your IP, and never sleeps.

---

## 1. What Is This? (In Plain English)
Imagine you hired a full-time digital assistant who:
*   Knows your brand colors, fonts, and voice.
*   Knows what makes a great online course (because it's been trained on proven strategies).
*   Can build you a website page, a lesson, or an email sequence by lunch.
*   Works 24/7 and never asks for a raise.

**That's CourseCreatorOS.** It lives on your computer. You talk to it. It builds things for you. That's it.

## 2. Key Components
*   **The Conversational Interface**: No complex dashboards. Just talk to it like a project manager.
*   **Smart Context System**: It reads your local Brand, Audience, and Product files before acting, ensuring every output is hyper-personalized.
*   **The Workflow Library**: Pre-trained "Skills" (e.g., `wf-create-lesson-html`, `wf-audit-website`) that handle complex, multi-step tasks automatically.
*   **Design Engine**: Generates bespoke, on-brand HTML components (flip-cards, timelines) on the fly.

---

## 3. System Architecture (Agent & Developer Guide)
This project is structured to allow AI Agents (like Gemini/Antigravity) to act as autonomous employees.

### Directory Structure
*   **`.agent/workflows/`**: The **"Skills"** library. These are the executable tasks the agent can perform.
    *   *Example*: `wf-create-lesson-html.md`, `wf-audit-website.md`.
*   **`.agent/rules/`**: The **"Persona"** & **"Rules"** folder. This defines the "Helpful Expert Friend" tone and "Non-Technical" audience constraints. **Agents MUST read `global-rules.md` upon startup.**
*   **`ccos/system/`**: The **"Brain"**. Contains core prompts, design standards, and instructional design patterns.
*   **`my-content/[company]/`**: The **"Memory"**. Contains user-specific data. Agents must respect these settings:
    *   `[name].context.md`: The Unified Context Bundle. Contains Brand, ICP, Tone, and Strategic data in a single file.
    *   `my-ccos/identity.md`: The User's Name and Role.

### Agent Behavior
*   **Workflow Integration**: Workflows like `/wf-set-context` and `/wf-create-context` are wired to automatically load `.agent/rules.md`.
*   **Personalization**: Agents should always greet the user by name (from `identity.md`) and tailor advice to their role.

---

## 4. The Ecosystem
Course Creator OS is more than just code; it's a supported environment.

*   **[The Community](https://community.superpowerups.com)**: Your home base.
    *   **The "Unstuck" Room**: Get past technical blockers fast.
    *   **Course Corrections**: Submit your lessons for a premium "Before & After" makeover.
    *   **Feedback Loop**: Get expert eyes on your designs before you launch.
*   **[The Context Corner](https://context.coursecreatoros.ai)**: The Marketplace.
    *   Download new **Brains** (Industry Contexts), **Skills** (New Workflows), and **Plans** to upgrade your OS.
*   **[Live Events](https://live.superpowerups.com)**: Weekly workshops and "Build with Me" sessions.
